﻿
const 
// общее число голов:
ГОЛОВ = 19;//35;
// общее число ног:
НОГ = 62;//94;
// макс. число кроликов:
МАКС_КРОЛИКОВ = НОГ div 4;
     
// РЕШАЕМ ЗАДАЧУ
procedure Solve();
begin   
   // решаем задачу:
   for var кроликов := 0 to МАКС_КРОЛИКОВ do begin
       // число фазанов:
       var фазанов := ГОЛОВ - кроликов;
       // печатаем ответ:
       if (фазанов * 2 + кроликов * 4 = НОГ) then begin
           WriteLn($' Кроликов: {кроликов}');
           WriteLn($' Фазанов:  {фазанов}');           
       end;
   end;
end;


procedure SolveGeneral(heads, legs: integer);
begin
    WriteLn($' Голов: {heads}  Ног: {legs}');

    // Проверяем возможность решения
    if legs mod 2 <> 0 then begin
        WriteLn($' Ошибка: общее число ног должно быть чётным!');
        exit;
    end;

    if legs < heads * 2 then begin
        WriteLn($' Ошибка: слишком мало ног (минимум {heads * 2})');
        exit;
    end;
   
    if legs > heads * 4 then begin
        WriteLn($' Ошибка: слишком много ног (максимум {heads * 4})');
        exit;
    end;

    // Решаем систему уравнений:
    // rabbits + pheasants = heads
    // 4*rabbits + 2*pheasants = legs

    // Из первого уравнения: pheasants = heads - rabbits
    // Подставляем во второе: 4r + 2(h - r) = legs
    // 4r + 2h - 2r = legs
    // 2r = legs - 2h
    // r = (legs - 2h) / 2

    var rabbits := (legs - 2 * heads) div 2;
    var pheasants := heads - rabbits;

    // Проверка
    if (rabbits * 4 + pheasants * 2 = legs) and 
       (rabbits >= 0) and
       (pheasants >= 0) then begin
        WriteLn($' Кроликов: {rabbits}');
        WriteLn($' Фазанов:  {pheasants}');
        WriteLn($' Проверка: {rabbits}×4 + {pheasants}×2 = {rabbits * 4 + pheasants * 2}');
    end
    else 
        WriteLn($' Решение не найдено')
end;
             

begin
   Writeln(' Китайские кролики и фазаны'); 
   Writeln(' Наука и жизнь, №3 за 1963, стр. 38, задача 6');    
   Writeln; 
   Solve();
   Writeln; 
   SolveGeneral(35, 94);  Writeln;
   SolveGeneral(19, 62);  Writeln;   
   SolveGeneral(6, 20);   Writeln;   
   SolveGeneral(35, 100); Writeln;    
   SolveGeneral(15, 42);  Writeln;     
end.
